import QtQuick 2.15
import QtQuick.Controls 2.15

Row {
    id: _root
    height: 24

    property string title: ""
    property string comment : ""
    property real step : 1
    property alias text: inputItem.text
    property alias validator: inputItem.validator

    signal editingFinished()

    Text {
        width: 100
        height: 24
        font.pointSize: 14
        text: parent.title
        verticalAlignment: Text.AlignVCenter
    }
    Button {
        width: 24
        height: 24
        text : "-"
        onClicked: {
            var num = parseFloat(inputItem.text)
            var value = Math.max(num - 1, inputItem.validator.bottom)
            inputItem.text = value.toFixed(2).replace(/\.0+$/, '')
            _root.editingFinished()
        }
    }
    Button {
        width: 24
        height: 24
        text : "-"
        onClicked: {
            var num = parseFloat(inputItem.text)
            var value = Math.max(num - 0.1, inputItem.validator.bottom)
            inputItem.text = value.toFixed(2).replace(/\.0+$/, '')
            _root.editingFinished()
        }
    }
    Rectangle {
        width: 100
        height: 24
        color: "white"
        border.color: "grey"
        TextInput {
            id: inputItem
            anchors.fill: parent
            anchors.margins: 2
            font.pointSize: 15
            text: "0"
            horizontalAlignment: Text.AlignHCenter
            onEditingFinished: {
                _root.editingFinished()
            }
        }
    }
    Button {
        width: 24
        height: 24
        text : "+"
        onClicked: {
            var num = parseFloat(inputItem.text)
            var value = Math.min(num + 0.1, inputItem.validator.top)
            inputItem.text = value.toFixed(2).replace(/\.0+$/, '')
            _root.editingFinished()
        }
    }
    Button {
        width: 24
        height: 24
        text : "+"
        onClicked: {
            var num = parseFloat(inputItem.text)
            var value = Math.min(num + 1, inputItem.validator.top)
            inputItem.text = value.toFixed(2).replace(/\.0+$/, '')
            _root.editingFinished()
        }
    }
    Text {
        width: contentWidth
        height: 24
        font.pointSize: 14
        text: parent.comment
        verticalAlignment: Text.AlignVCenter
    }
}
